/* Antarmuka dengan Sensor Ultrasonic - Trainer Internet of Things
 * Project : Range Meter dengan Sensor Ultrasonik Berbasi IoT
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
// Library Sensor Ultrasonic
#include <NewPing.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// Mengatur PIN dan jarak maksimal
#define T  D5     // PIN T (Trig) terhubung ke PIN D5 NodeMCU
#define E  D6     // PIN E (Echo) terhubung ke PIN D6 NodeMCU
#define Maks 200  // Jarak maksimal yang diukur
NewPing us(T, E, Maks);

// Firebase objek dengan nama fbdo
FirebaseData fbdo;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// Variabel jarak menyimpan data sensor ultrasonic
int jarak;
// Variabel untuk menyimpan karakter data sensor
char val_jarak[3];

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200); 
  
  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() { 
  // Data pembacaan sensor disimpan pada 'jarak'
  jarak = us.ping_cm();
  sprintf(val_jarak, "%3d", jarak);

  // Mencetak data pada serial monitor
  Serial.println("Jarak:" + String(jarak) + " cm");

  // Mengirim data sensor ultrasonik ke database
  // dengan alamat *user/gauge1
  Firebase.set(fbdo, "/" + user + "/hlevel1", jarak);

  // Mencetak Teks "Jarak (cm)" pada OLED
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(1,1);
  display.print("Jarak (cm)");
  
  // Mencetak data sensor pada OLED
  display.setTextSize(3);
  display.setTextColor(WHITE);
  display.setCursor(1,25);
  display.print(val_jarak);

  display.display();      // Menampilkan data
  display.clearDisplay(); // Membersihkan tampilan display
}
